function [a,d] = slwd(x,D_Lo,D_Hi)

% Single-Level Wavelet Decomposition (for purposes of SegWT)
%
% x....input vector
% D_Lo,D_Hi...decomposition filters
%
% a....resultant aprox. coefficients
% d....resultant detail coefficients

%l=length(x);
m = length(D_Lo); % filter length

% 1. Extending the vector
% we omit this step in contrast to the classical pyramidal algorithm

% 2. Convolution
x_lowpassed = conv(x,D_Lo);
x_hipassed = conv(x,D_Hi);

% 3. Keeping just the central part, i.e. removing (m-1) values from both ends
%%%%%%%%%%x_low_kept = x_lowpassed(lf:(lf+(lx+lf-1)-1));
keep_ind = m:(length(x_lowpassed)-(m-1));   %indexes which will be kept
x_low_kept = x_lowpassed(keep_ind);
x_hi_kept  = x_hipassed(keep_ind); 

% 4. Downsampling (even)
a = dyaddown(x_low_kept);
d = dyaddown(x_hi_kept);