function [signal, fragments] = segidtwt(coefs,L,R_Lo,R_Hi)

% SEGIDTWT function computes the inverse segmented wavelet transform (multilevel)
%
% coefs.......wavelet coefficients, as produced by segdtwt.m
% L...........bookkeeping matrix containing numbers of coefficients computed 
%             from the individual segments. Also produced by segdtwt.m.
% R_Lo,R_Hi...wavelet reconstruction filters
%
% signal......signal in time domain reconstructed segment-by-segment
% fragments...vector of lengths of fragments within the reconstruction procedure
%             ([central overlap central ... central overlap])
%             The last number could be negative - that means that the last
%             piece had to be shortened by the respective number of samples.
%
% Offline version, the algorithm does not produce the output segment
% synchronously with the input signal segments
%
% Example:
%   db2_R_Lo = wfilters('db2','lr');  db2_R_Hi = wfilters('db2','hr');
%   [signal_rec, frg, rozdil] = segidtwt(coefs,L,db2_R_Lo,db2_R_Hi);
% 
% See also SEGDTWT

% (c) 2007-2008 Pavel Rajmic
% Dept. of Telecommunications, FEEC, Brno University of Technology, Czech Republic

% last revision 2008-Jan-12

% vychazi castecne z DP Josefa Vyorala, FEEC BUT 2007
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% initialization of counters etc.
d = size(L,1) - 2;          % the decomposition depth
m = length(R_Lo);           % filter length (orthogonal)
seg_no = 1;                 % number of current segment
last_segment = 0;           % flag indicating that the last segment was received
seg_signal = {};            % bunka pro docasne useky vysledneho signalu
overlap_len = hmcs(d,m);    % pocet prvku prekryti
signal = [];                % vystupni signal
fragments = [];             % pomocny vystup
par = logical(0);           % parity (boolean)

% zjisteni delky segemntu (v pripade ze jde o jediny segment je to vlastne
% maximalni delka segmentu, i kdyz mohla byt predepsana puvodne vetsi)
s = L(1,1);             

% % virtual overlap from the zeroth segment to the first segment
% to_add = zeros(1,overlap_len);

%% Main loop
while last_segment == 0
    % nacteni segmentu
    [seg_coefs, last_segment] = read_seg_coefs(coefs,L,seg_no);
    
    % rozsireni detailnich koeficientu nulami zleva
    for ind = 1:(d-1)
        %seg_coefs{ind} = [ zeros(1,hmcs(d-ind,m)) seg_coefs{ind} ];
        seg_coefs{ind} = extend(seg_coefs{ind},'left','zeros',hmcs(d-ind,m));
    end
    
    % inverzni transformace jednoho segmentu
    seg_signal{seg_no} = mlwr(seg_coefs,d,R_Lo,R_Hi);
    seg_signal_len = length(seg_signal{seg_no});

    %%% "overlap-add" jednotlivych segmentu
    
%     % pricteni presahu z minuleho segmentu
%     current_output = seg_signal{seg_no}(1:overlap_len) + to_add;

    if seg_no == 1 % pokud je segment prvni
        current_output = [];
    else
        % pricteni presahu z minuleho kola
        current_output = seg_signal{seg_no}(1:overlap_len) + to_add;
    end
    
    % parity of the total length of read signal (even...0, odd...1)
    % - knowledge of this is sufficient for the correct cutting of the last
    % piece of the signal at the very end
    par = parity(par,L(1,seg_no));
    
    if last_segment
        % v pripade posledniho segmentu pripojime veskery zbytek k vystupu
        % (muze vyjit i prazdne), ale zaroven muze byt odebrano poslednich
        % nekolik vzorku signalu, aby byl vystupni signal stejne delky jako
        % vstupni
        % Find out the difference between the length of the last segment
        % and the length of the respective right extension
        rmin_vec = rmin(d,s);           % basic period of the vector of the right extensions
        period   = length(rmin_vec);    % length of the period
        % Index in 'rmin_vec', which comes from {1,2,...,period}, could be simply
        % computed as "index = mod(seg_no-2,period) + 1"
        % but in case 'seg_no' is small we could fall into negative numbers (not
        % good for the purpose of rewriting the code into C); and because 'period'
        % could be 1 by smallest, we compute the index equivalently by:
        index = mod(seg_no+3*period-2,period) + 1;
        difference = rmin_vec(index) - L(1,end);
        % correction (in fact, by this we avoid an IF branch)
        difference = max([par difference]);       
        % Uriznuti konce signalu (ktere je nutne udelat v pripade, ze posledni
        % segment byl kratsi nez prislusne Rmin)
        indexes = (overlap_len+1):(seg_signal_len-m+2);
        current_output = [current_output seg_signal{seg_no}(indexes)];
        current_output = current_output(1:end-difference); %crop
        
        % for the auxiliary output
        % the current fragment cannot be shorter that 0, however, negative
        % number at the last position means that the end of the signal has
        % been shortened
        fragments = [fragments (length(indexes)-difference)];
        
    else
        % K vystupu pripojime prostredni cast, ktera se nebude s nicim
        % prekryvat (teoreticky asi muze vyjit i prazdna).
        % U prvniho segmentu tato prostradni cast znamena presne zacatek
        % rekonstruovaneho signalu.
        centerpart = seg_signal{seg_no}((overlap_len+1):(seg_signal_len-overlap_len));
        current_output = [current_output centerpart];
        % for the auxiliary output
        fragments = [fragments length(centerpart)];
        
        % presah - nove hodnoty k pricteni v pristim kole
        to_add = seg_signal{seg_no}((seg_signal_len-overlap_len+1):seg_signal_len);
        fragments = [fragments length(to_add)];
    end

    % vystupni vektor, jehoz hodnoty se jiz nebudou menit
    signal = [signal current_output];
    
    
%     if last_segment
%         % Find out the difference between the length of the last segment
%         % and the length of the respective right extension
%         rmin_vec = rmin(d,s);           % basic period of the vector of the right extensions
%         period   = length(rmin_vec);    % length of the period
%         % Index in 'rmin_vec', which comes from {1,2,...,period}, could be simply
%         % computed as "index = mod(seg_no-2,period) + 1"
%         % but in case 'seg_no' is small we could fall into negative numbers (not
%         % good for the purpose of rewriting the code into C); and because 'period'
%         % could be 1 by smallest, we compute the index equivalently by:
%         index = mod(seg_no+3*period-2,period) + 1;
%         difference = rmin_vec(index) - L(1,end);
%         
%         % correction (in fact, by this we avoid an IF branch)
%         difference = max([par difference]);
%         
%         % Uriznuti konce signalu (ktere je nutne udelat v pripade, ze posledni
%         % segment byl kratsi nez prislusne Rmin)
%         signal = signal(1:end-difference);
%     end
    
    % increase the segment counter
    seg_no = seg_no+1;
end



% % Info: kolik se jich schovava z jednoho segmentu do nasledujiciho vystupu
% schovavani = uschovej(fragments,L(1,:));
% 
% 
% 
% %%%%%%%%
% function out = uschovej(frg,segments_lengths)
% % pocita, kolik vzorku rekonstruovaneho segmentu patri spravne do pristiho
% % (tj. kolik by se jich melo uschovat pro vystup az v pristim kole)
%     c = 0;
%     out = [];
%     for cnt = 1:((length(frg)-1)/2) 
%         c = (c + frg(cnt*2-1) + frg(cnt*2)) - segments_lengths(cnt); % frg(cnt*2) je vlastne delka presahu
%         out = [out c];
%     end
% return