function pmin_vector = rmin(J,s)

% RMIN returns the first basic period of right extensions of segments, i.e.
% [Rmin(1), Rmin(2),...,Rmin(N)]
% N=2^(J-k) where J is the transform depth and k is the
% greatest integer such that s is divisible by 2^k. The length od the
% period, N, is restricted by 1 from below.
%
% s.......segment legth
% J.......transform depth
%
% see also GDPT

% (c) 2004-2008 Pavel Rajmic
% Dept. of Telecommunications, FEEC, Brno University of Technology, Czech Republic

% last revision 2008-Sep-12


% compute the period and initialize the array
k = gdpt(s);

% The length of the period can not be less than 1, so k has to be
% restricted in certain cases
if k > J
    k = J;
end

N = 2^(J-k);
Pmin = zeros(1,N);

% compute the extensions
for cnt = 1:N
    pmin_vector(cnt) = 2^J*ceil(cnt*s/2^J) - cnt*s;
end