function [vector, last] = read_segment(x,len,number)

% Auxiliary function, which simulates receiving signal segment by segment.
% We suppose all the segments but the last one have the same lengh.
% The last segment could be shorter than 'len'. 
%
% x.......the whole signal
% len.....length of segment
% number...number of segment (1,2,3,...)
%
% vector...segment returned
%          or empty matrix [] which means that there are no more samples left
% last.....boolean; if the currently read segment is the last one, it is indicated by last=1

% last revision 2008-Sep-23


%% initialization
lx = length(x);
begin_ind = (number-1)*len+1;
last = 0;

%% body
if begin_ind > lx
    disp('Warning...index exceeded...no more samples...output will be empty matrix')
    vector = [];
else
    stop_ind = begin_ind+len-1;     % ending index of the segment
    if stop_ind >= lx               % if the segment is shorter than len or equal
        stop_ind = lx;
        last = 1;                   % it has been the last segment
    end
    vector = x( begin_ind : stop_ind );
end