function [seg_coefs, last] = read_seg_coefs(coefs,L,number)

% reads coefficients obtained by SegDTWT from segment number "number"
%
% coefs......coefficients as produced by segdtwt.m
% L..........auxiliary matrix (also produced by segdtwt.m)
% number.....the order of the desired segment's coefficients
%
% seg_coefs..the desired coefficients
% last.......boolean - true if the required segment is the last one

% (c) 2007, Pavel Rajmic, UTKO FEKT VUT v Brne


% zjisteni hloubky dek.
d = size(L,1) - 2;

% priprava vystupni bunky
seg_coefs = {};
seg_coefs(d+1) = {[]};

% zjisteni posledniho segmentu
last = (number == size(L,2));

% vypocet zacatecniho a koncoveho indexu
L1 = L(2:d+2,1:number-1);       % pomocna uprava L (vyrez)
L1 = sum(L1,2);                 % soucet po radcich (tzn. kolik uz jich bylo)
begin_index_set = L1+1;
end_index_set = begin_index_set + L(2:d+2,number) - 1;
clear L1

% naplneni vystupni bunky
for cnt = 1:d+1
    seg_coefs(cnt)= {coefs{cnt}( begin_index_set(cnt):end_index_set(cnt) )};
end