function out_parity = parity(last_parity,new_number)

% PARITY returns (progressive) parity of the sum of two last lengths
% of segments.
% Parity: 0...even, 1...odd
%
% last_parity....(boolean) parity of the preceeding length (known from before)
% new_number.....length of actually processed segment
%
% out_parity.....parity of the sum of the two

% (c) 2007-2008 Pavel Rajmic
% Dept. of Telecommunications, FEEC, Brno University of Technology, Czech Republic

% last revision 2008-Sep-11

new_parity = logical(rem(new_number,2));
out_parity = xor(last_parity, new_parity);