function y = mlwr(coefs,d,R_Lo,R_Hi)
% reconstructs signal segment from coefficients "coefs" of depth "d" using
% reconstruction filters "R_Lo" and "R_Hi"

% last revision 2008-01-16

m = length(R_Lo);   % orthogonal filters
actual_depth = d;
y = coefs{d+1};

while actual_depth >= 1
    dets = coefs{actual_depth};
    % pripadne orezani aproximaci (predpokladam ze maximalne jeden prvek) na spravnou
    % delku, kterou zjistim z prislusnych detailu
    % (v max. hloubce pochopitelne bez ucinku)
    aprs = y(1:length(dets));
    
    % 1. Upsampling (even)
    aprs_up = dyadup(aprs);
    dets_up = dyadup(dets);

    % 2. Filtering
    y_low  = conv(aprs_up,R_Lo);
    y_high = conv(dets_up,R_Hi);
    
    % 3. Sum
    y = y_low + y_high;
    
    actual_depth = actual_depth - 1;
end

% orezani v casove domene - PROC ZROVNA TOLIK?
y = y(1:(2*length(coefs{1})+(m-1))); % na lichy pocet