function coefs = mlwd(x,d,D_Lo,D_Hi)

% Multi-Level Wavelet Decomposition (modified for SegWT, without extending the borders in every cycle)
%
% x...........signal to be decomposed
% d...........decomposition depth
% D_Lo,D_Hi...decomposition filters
%
% coefs.......cell array - from first detail to last approximation coefs
%         (   i.e., coefs consist of d+1 cells)

actual_depth = 1;
to_filter_now = x;

while actual_depth <= d
    [aprs,dets] = slwd(to_filter_now,D_Lo,D_Hi);    % calling single level decomposition
    coefs{actual_depth} = dets;
    to_filter_now = aprs;
    actual_depth = actual_depth+1;
end

coefs{actual_depth} = to_filter_now;                % the last approx. coefs