function lmax_vector = lmax(rmin_vector,ext_length)

% LMAX returns the first basic period of left extensions of segments, i.e.
% [Lmax(1), Lmax(2),...,Lmax(N)]
% N=2^(J-k) where J is the transform depth and k is the
% greatest integer such that s is divisible by 2^k
%
% rmin_vec.......the first basic period of right extensions of segments
%                (e.g. computed by rmin.m)
% ext_length.....total extension length (e.g. computed by hmcs.m)
%
% see also RMIN, HMCS

% (c) 2004-2008 Pavel Rajmic
% Dept. of Telecommunications, FEEC, Brno University of Technology, Czech Republic

% last revision 2008-Sep-02


lmax_vector = ext_length - rmin_vector;   %vector of differences; always nonnegative
lmax_vector = circshift(lmax_vector',1)'; %circularly shift to the right

% check
%[1:length(lmax_vector);lmax_vector;rmin_vector]