function extended = extend(original,side,type,number)

% EXTEND_SAMPLES appends a certain number of samples to the input
%
% original....
% side........'left' or 'right'
% type........'zeros' or directly the vector of samples
% number......number of samples to extend; this parameter must be present
%             iff type is 'zeros'
%
% The extension could be of length 0 i.e. an empty matrix.
%
% Examples:
%   extend_samples(1:5,'left','zeros',8)
%   extend_samples(1:5,'left',[10 8 6])

% Pavel Rajmic
% Last revision 2008-Sep-24


%% input parameters check and forming the extension vector
if (nargin < 3)
    error('Not enough input params')
elseif ischar(type) && isequal(type,'zeros')
    if nargin == 3
        error('Number of zeros must be input')
    else % nargin == 4
        if isnumeric(number)
            extension = zeros(1,number); % extension is made of zeros
        end
    end
else % type ~= 'zeros' (numeric vector)
    if nargin == 4
        error('Too many input params in this case')
    else % nargin == 3
        extension = type; % extension is directly the input vector
    end
end

%% extension
switch side
    case 'left'     % from left
        extended = [extension original];
    case 'right'    % from right
        extended = [original extension];
end