function coefs_cut = cut_redundant(coefs,m,side)

% Cuts redundant coefficients from the wavelet spectrum, contained in "coefs".
% For SegDTWT method.
%
% coefs......coefficients computed within segdtwt.m
% m..........wavelet filter length
% side.......defines from which side have the coefficients to be cut
%            'right' or 'left'
%
% coefs_cut..trimmed coefficients

% (c) 2004-2008 Pavel Rajmic
% Dept. of Telecommunications, FEEC, Brno University of Technology, Czech Republic

% last revision 2008-01-30


if ~(strcmp(side,'left') || strcmp(side,'right'))
    error('Wrong parameter')
end

lc = length(coefs);
d = lc-1;                       % decomposition depth

for ind = 1:(lc-2)
    hm_to_cut = hmcs(d-ind,m);  % How Many coefficients To be Cut in (ind)-th level
    switch side
        case 'left'
            % cutting the left part, leaving the rest
            coefs_cut{ind} = coefs{ind}( hm_to_cut+1 : length(coefs{ind}));
        case 'right'
            % cutting the right part, leaving the rest
            coefs_cut{ind} = coefs{ind}( 1 : length(coefs{ind})-hm_to_cut );
    end
end

coefs_cut{lc-1} = coefs{lc-1};  % last details and
coefs_cut{lc}   = coefs{lc};    % last approx. don't have to be cut
